/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.security;

import eu.gemss.components.security.token.SecurityToken;
import eu.gemss.components.security.token.TokenDescriptor;
import eu.gemss.components.security.token.TokenDescriptor;

/**
 * GEMSSSecurityContext describes the functionality provided by a GEMSS component that
 * provides a security context for the GEMSS framework
 */
public interface GEMSSSecurityContext {
	/**
	 * Generate a security token for the passed token descriptor, it is not automatically stored in the context
         * Calling this method several times could produce different security tokens.
	 * @param tokenDesc token descriptor
	 * @return security token
	 */
	public SecurityToken generateSecurityToken(TokenDescriptor tokenDesc) throws eu.gemss.GridException;

	/**
	 * Test to see if the passed security token is trusted in the prevailing security context
	 * @param token
	 * @return true if token is trusted
	 * @throws SecurityContextException
	 */
        public boolean isTrusted(SecurityToken token) throws eu.gemss.GridException;

        /**
         * Add a security token instance to the prevailing security context
         * @param secToken security token to add
         * @throws SecurityContextException
         */
        public void addSecurityTokenToContext(SecurityToken secToken) throws eu.gemss.GridException;

        /**
         * Remove from the prevailing security context the security token identified by the supplied token descriptor
         * @param secToken security token to remove
         * @throws SecurityContextException
         */
        public void removeSecurityTokenFromContext(SecurityToken secToken) throws eu.gemss.GridException;

        /**
         * Retrieve from the prevailing security context a previously stored security token matching the passed token descriptor
         * @param tokenDesc token identifier
         * @return security token required
         * @throws SecurityContextException
         */
        public SecurityToken getSecurityToken(TokenDescriptor tokenDesc) throws eu.gemss.GridException;
}
