/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.security;

import eu.gemss.GridException;

/**
 * The class InvalidCredentialException is thrown by the transport component
 * when an operation invocation is requested for which there an invalid certificate provided.
 * This exception will originate from the GEMSSSecurityContext component and be passed straight through
 * by the transport component. This type of exception will
 * normally be resolved by changing the certificate used to be that generated for the current users.
 */
public class InvalidCredentialException extends SecurityContextException {
    /**
     * Creates a new InvalidCredentialException with the specified
     * user and system messages.
     * @param userMsg a <code>String</code> containing a message intended for the user.
     * @param systemMsg a <code>String</code> containing a message intended for the system administrator or application developer.
     */
    public InvalidCredentialException( String userMsg, String systemMsg ) {
        super( userMsg,systemMsg );
    }
}
