/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.security.token;

/**
 * TokenDescriptor is a interface that all types of token descriptor must implement.
 * The only method is used to check for equality between two instances of TokeneDescriptor.
 * The idea is that new token providers can produce a token descriptor that handles
 * the specific details of what the token provides.
 */
public interface TokenDescriptor {

    /**
     * Retrieve a short string description for the token type
     * @return token description
     */
    public String getDescription();

    /**
     * Check if tokenID matches the passed one
     * @param tokenDesc token identifier to check against
     * @return true if passed tokenID is the same, false otherwise
     * @exception IllegalArgument If the passed tokenID cannot be compared
     */
    public boolean isEqual(TokenDescriptor tokenDesc);


}