/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.security.token.provision;

//import uk.ac.soton.itinnovation.gemss.security.context.provider.control.ProviderController;
import eu.gemss.components.security.token.TokenDescriptor;
import eu.gemss.components.security.token.SecurityToken;
import eu.gemss.components.security.token.types.UnsupportedTokenException;
import eu.gemss.components.security.SecurityProviderConfiguration;
import eu.gemss.components.security.*;
import eu.gemss.signals.SignalHandler;

public interface SecurityTokenProvider {

    /**
     * Retrieve a list of all the token types supported by the provider
     * @return list of token descriptors
     */
    public TokenDescriptor[] getSupportedTokenList();

    /**
     * Generate an instance of the token of a particular type described
     * by the token descriptor
     * @param tokenDesc descriptor for required token
     * @return instance of the required security token
     */
    public SecurityToken generateSecurityToken(TokenDescriptor tokenDesc) throws UnsupportedTokenException, TokenProviderException, InvalidCredentialException;

    /**
     * Sets the channel where provider signals should be sent
     * @param channel
     */
    public void setSignalHandler(SignalHandler channel);

    /**
     * Set the security token provider configuration
     * @param configuration
     */
    public void setTokenProviderConfiguration(SecurityProviderConfiguration configuration);
}
