/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.security.token.store;

import eu.gemss.components.security.token.*;
import eu.gemss.components.security.token.types.UnsupportedTokenException;
import eu.gemss.components.security.*;
import eu.gemss.signals.SignalHandler;

import uk.ac.soton.itinnovation.gemss.security.context.*;

public interface SecurityTokenStoreProvider {


    /**
     * Retrieve a list of all the token types supported by the provider
     * @return list of token descriptors
     */
    public TokenDescriptor[] getSupportedTokenList();

    /**
     * Checks to see if the the store holds the supplied Token identifier
     * @param tokenDesc identifier for token
     * @return true if it does hold the token instance or false otherwise
     */
    public boolean contains(TokenDescriptor tokenDesc);

    /**
     * Retrieve an instance of the token of a particular type described
     * by the token descriptor
     * @param tokenDesc descriptor for required token
     * @return instance of the required security token
     */
    public SecurityToken getSecurityToken(TokenDescriptor tokenDesc) throws UnsupportedTokenException, StoreProviderException, eu.gemss.components.security.InvalidCredentialException;


    /**
     * Add a security token instance to this store
     * @param secToken token to add
     * @return true if succeed, false otherwise
     * @throws UnsupportedTokenException
     * @throws StoreProviderException
     */
    public boolean addSecurityToken(SecurityToken secToken) throws UnsupportedTokenException,StoreProviderException;

    /**
     * Remove a security token instance from this store
     * @param secToken token to remove
     * @return true if succeed, false otherwise
     * @throws UnsupportedTokenException
     * @throws StoreProviderException
     */
    public boolean removeSecurityToken(SecurityToken secToken) throws UnsupportedTokenException, StoreProviderException;

    /**
     * Sets the handler where provider signals should be sent
     * @param handler
     */
    public void setSignalHandler(SignalHandler handler);

    /**
     * Set the security token provider configuration
     * @param configuration
     */
    public void setStoreProviderConfiguration(SecurityProviderConfiguration configuration);
}
