/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.security.token.trust;


import eu.gemss.components.security.token.TokenDescriptor;
import eu.gemss.components.security.token.SecurityToken;
import eu.gemss.components.security.token.types.UnsupportedTokenException;
import eu.gemss.signals.SignalHandler;
import eu.gemss.components.security.*;

public interface SecurityTrustProvider {

    /**
     * Retrieve a list of all the token types supported by the provider
     * @return list of token descriptors
     */
    public TokenDescriptor[] getSupportedTokenTrustList();

    /**
     * Test if the supplied security token is trusted
     * @param secToken security token
     * @return true if trusted, false otherwise.
     */
    public boolean isTrusted(SecurityToken secToken) throws UnsupportedTokenException, TrustProviderException;

    /**
     * Sets the channel where provider signals should be sent
     * @param channel
     */
    public void setSignalHandler(SignalHandler channel);

    /**
     * Set the security trust provider configuration
     * @param configuration
     */
    public void setTrustProviderConfiguration(SecurityProviderConfiguration configuration);

}
