/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.security.token.types.key.asymmetric;

import eu.gemss.components.security.token.TokenDescriptor;

/**
 * AssymmetricKeyDescriptor is a concrete implementation of the interface
 * TokenDescriptor and identifies the type used by assymmetric keys
 */
public class AsymmetricKeyDescriptor implements TokenDescriptor {

    /**
     * Token is Private Key token
     */
    public static final int PRIVATE_KEY = 0;

    /**
     * Token is Public Key token
     */
    public static final int PUBLIC_KEY = 1;

    /**
     * Token is a Key pair token
     */
    public static final int KEY_PAIR = 2;

    /**
     * Asymmetric cypher algorithm RSA
     */
    public static final int CYPHER_ALGO_RSA = 0;
    /**
     *Asymmetric cypher algorithm DSA
     */
    public static final int CYPHER_ALGO_DSA = 1;

    private int mCypherAlg;
    private int mKeyType;
    private static final String mDescription = "Asymmetric Key Token";

    /**
     * Constructor creates a default descirptor that will use RSA and point to a keypair token
     */
    public AsymmetricKeyDescriptor() {
        mCypherAlg = CYPHER_ALGO_RSA;
        mKeyType = KEY_PAIR;
    }

    /**
     * Constructor allows the setting of a particular cypher type and key length
     * @param type type of token either private key, public key or keypair
     * @param cypherAlg cypher algorithm
     */
    public AsymmetricKeyDescriptor(int type,int cypherAlg) {
        mKeyType = type;
        mCypherAlg = cypherAlg;
    }

    /**
     * Check if tokenID matches the passed one
     * @param tokenDesc token identifier to check against
     * @return true if passed tokenID is the same both in terms of type and value, false otherwise
     */
    public boolean isEqual(TokenDescriptor tokenDesc) {

        if(tokenDesc instanceof AsymmetricKeyDescriptor) {
            AsymmetricKeyDescriptor aTD = (AsymmetricKeyDescriptor) tokenDesc;
            if(aTD.getCypherAlg()==mCypherAlg)
                return true;
        }
        return false;
    }

    /**
     * Retrieve the cypher algorithm for token type
     * @return cypher algorithm type
     */
    public final int getCypherAlg() {
        return mCypherAlg;
    }

    public final String getDescription() {
        return mDescription;
    }

}

