/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.security.token.types.pki;

import eu.gemss.components.security.token.TokenDescriptor;
import eu.gemss.components.security.token.types.key.asymmetric.AsymmetricKeyDescriptor;

/**
 * X509CertificateChainDescriptor is a full description of a chain of X509Certificates.
 */
public class X509CertificateChainDescriptor implements TokenDescriptor {

    private static final String mDescription = "PKI Certificate Chain Token";
    private boolean mAccepted = false;

    /**
     * Constructor creates a Certificate Chain that is either made up of
     * accepted issuers or not.
     */
    public X509CertificateChainDescriptor(boolean accepted) {
        mAccepted = accepted;
    }

    /**
     * Check if this descriptor matches the passed one
     * @param tokenDesc token descriptor to check against
     * @return true if passed descriptor is the same both in terms of type and value, false otherwise
     */
    public boolean isEqual(TokenDescriptor tokenDesc) {

        if(tokenDesc instanceof X509CertificateChainDescriptor) {
            X509CertificateChainDescriptor desc = (X509CertificateChainDescriptor) tokenDesc;
            if(desc.isAccepted()==mAccepted)
                return true;
            else
                return false;
        }
        return false;
    }

    public final String getDescription() {
        return mDescription;
    }

    public final boolean isAccepted() {
        return mAccepted;
    }

}


