/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.security.token.types.pki;

import eu.gemss.components.security.token.SecurityTokenException;
import java.security.cert.X509Certificate;
import eu.gemss.components.security.token.SecurityToken;

/**
 * X509CertificateChainToken describes a chain of certificates
 */
public interface X509CertificateChainToken extends SecurityToken{

    /**
     * Retrieve a certificate chain
     * @return chain
     */
    public X509Certificate[] getX509CertificateChain();

    /**
     * Retrieve authentication type based on the server certificate
     * @return authType
     */
    public String getAuthType();

}
