/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.security.token.types.pki;

import eu.gemss.components.security.token.types.key.asymmetric.PublicKeyToken;
import eu.gemss.components.security.token.SecurityTokenException;
import java.security.cert.X509Certificate;

/**
 * X509CertificateToken describes the information obtainable from a security
 * token that represents an X509Certificate.
 */
public interface X509CertificateToken extends CertificateToken{

    /**
     * Retrieve the issuer distinguished name for this certificate
     * @return issuer distinguised name
     */
    public String getIssuerDN() throws SecurityTokenException;

    /**
     * Retrieve the subject distinguished name for this certificate
     * @return subject distinguished name
     */
    public String getSubjectDN() throws SecurityTokenException;

    /**
     * Retrieve the X509Certificate for this certificate token
     * @return certificate X509 certificate
     */
    public X509Certificate getX509Certificate() throws SecurityTokenException;

}
