/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.transport;

import eu.gemss.components.transport.servicedescription.*;
import java.io.*;
import java.util.*;
import eu.gemss.*;

/**
 * TransportMessaging interface defines the responsibilities of all
 * providers for the GEMSS Transport and Messaging Component.
 */
public interface GEMSSTransportAndMessaging extends Serializable {

    /**
     * Invokes the service described by the passed service description using input data
     * contained in the passed input container. This is a blocking call.
     * @param serviceDesc service description
     * @param input input data container
     * @return Invocation output associated with this invocation, used to get the return payload
     */
    public InvocationOutput invokeService(ServiceDescription serviceDesc, InvocationInput input) throws GridException ;

    /**
     * Invokes the service described by the passed service description using input data
     * contained in the passed input container. This is a blocking call.
     * @param serviceDesc service description
     * @param input input data container
     * @param fileHandles map from return item names to file destination paths
     * @return Invocation output associated with this invocation, used to get the return payload
     */
    public InvocationOutput invokeService(ServiceDescription serviceDesc, InvocationInput input, Map fileHandles) throws GridException ;

    /**
     * Invokes the service described by the passed service description using input data
     * contained in the passed input container. This is a blocking call.
     * @param serviceDesc service description
     * @param input input data container
     * @param usePolicyFile if use static policy file set to true, false otherwise
     * @return Invocation output associated with this invocation, used to get the return payload
     */
    public InvocationOutput invokeService(ServiceDescription serviceDesc, InvocationInput input, boolean usePolicyFile) throws GridException ;

    /**
     * Invokes the service described by the passed service description using input data
     * contained in the passed input container. This is a blocking call.
     * @param serviceDesc service description
     * @param input input data container
     * @param fileHandles map from return item names to file destination paths
     * * @param usePolicyFile if use static policy file set to true, false otherwise
     * @return Invocation output associated with this invocation, used to get the return payload
     */
    public InvocationOutput invokeService(ServiceDescription serviceDesc, InvocationInput input, Map fileHandles, boolean usePolicyFile) throws GridException ;
}
