/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.transport;

import eu.gemss.components.transport.OperationException;

/**
 * The class InputArgument is thrown by the transport component
 * when a web service invocation has failed to use the correct operation argument names
 * or types as defined in the service WSDL. This exception can also be thrown if the
 * operation cannot process (for example parsing an XML document arg) the arg data due
 * to some problem with the format of it.
 */
public class InputArgumentException extends OperationException {
    /**
     * Creates a new InputArgumentException with the specified
     * user and system messages.
     * @param userMsg a <code>String</code> containing a message intended for the user.
     * @param systemMsg a <code>String</code> containing a message intended for the system administrator or application developer.
     */
    public InputArgumentException( String userMsg, String systemMsg ) {
        super( userMsg,systemMsg );
    }
}
