/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.transport;

import eu.gemss.components.transport.OperationException;

/**
 * The class OperationExec is thrown by the transport component
 * when a web service invocation has executed the operation using the
 * arguments provided, and an error code / execption was generated.
 * There will be an operation specific reason for this failure,
 * which will be communicated via the system and user message fields.
 */
public class OperationExecException extends OperationException {
    /**
     * Creates a new OperationExecException with the specified
     * user and system messages.
     * @param userMsg a <code>String</code> containing a message intended for the user.
     * @param systemMsg a <code>String</code> containing a message intended for the system administrator or application developer.
     */
    public OperationExecException( String userMsg, String systemMsg ) {
        super( userMsg,systemMsg );
    }
}
