/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.transport.payload;

import java.io.Serializable;

/**
 * DataItem represents a single atomic data value. This interface describes methods for
 * obtaining information about that data item.
 */
public interface DataItem extends Serializable {

    /**
     * Retrieve the identifying name for this data item
     * @return name
     */
    public String getName();

    /**
     * Retrieve the type description for this data item
     * @return type description
     */
    public TypeDescription getTypeDescription();

    /**
     * Retrieve the data value object for this data item,
     * this may return null if the data item has been released.
     * @return value object
     */
    public Object getValue();

    /**
     * Check to see if the value object is a string file reference to the actual data value.
     * @return data value file path
     */
    public boolean isValueFileReference();

    /**
     * Releases the data represented by this data item
     * This is to make it available for garbage collection
     */
    public void releaseData();

	/**
	 * Set the data item translator for this dataitem. The passed translator will be used
	 * by the underlying infrastructure to serialize the data item value into a W3C DOM Element object (org.w3c.dom.Element) and back again.
	 */
	public void setDataItemDOMTranslator(DataItemDOMTranslator dataItemDOMTranslator);

	/**
	 * Retrieve the data item translator assigned to this data item value.
	 * @return translator
	 */
    public DataItemDOMTranslator getDataItemDOMTranslator();
}
