/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.transport.payload;

import eu.gemss.components.transport.payload.DataItem;
import javax.xml.namespace.QName;

/**
 * DataItemDOMTranslator interface describes the responsibilities placed on all data item
 * serialisers. Basic implementations will exist for simple primitive data types like
 * int, boolean etc. Additional implementations need only be created if an application has specialist
 * data types. The interface uses instances of org.w3c.dom.Element
 */
public interface DataItemDOMTranslator extends java.io.Serializable {

    /**
     * Output the passed data item into a DOM Element
     * @param dataItem
     * @return DOM Node
     * @throws DataItemTranslationException
     */
    org.w3c.dom.Node outputDOM(DataItem dataItem) throws PayloadException;

    /**
     * Output the passed DOM Element into a DataItem
     * @param node node to convert
     * @param qName of parent element
     * @return data item
     * @throws DataItemTranslationException
     */
    DataItem outputDataItem(org.w3c.dom.Node node,javax.xml.namespace.QName qName) throws PayloadException;

    /**
     * Test if the translator can handle the passed data item
     * @param dataItem
     * @return true if can handle, false otherwise
     * @throws PayloadException
     */
    public boolean canHandle(DataItem dataItem) throws PayloadException;

    /**
     * Test if the translator can handle the passed element
     * @param node
     * @return true if can handle, false otherwise
     * @throws PayloadException
     */
    public boolean canHandle(org.w3c.dom.Node node) throws PayloadException;

    /**
     * Checks to see if the passed translator is of the same type as this one
     * @param translator DataItemDOMTranslator to check
     * @return true if match, false otherwise.
     */
    public boolean isSameTranslator(DataItemDOMTranslator translator);

    /**
     * Retrieve the QName used to describe the passed value
     * @param value
     * @return qualified name
     */
    public QName getTypeOfObjectAsQName(Object value) throws PayloadException;
}