/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.transport.payload;

import java.io.Serializable;
import javax.xml.namespace.QName;

/**
 * TypeDescription interface describes information that can obtained about any
 * concrete data type.
 */
public interface TypeDescription extends Serializable {

    /**
     * Checks to see if the passed type description matches this one
     * @param typeToCompare type to compare
     * @return true if match false otherwise
     */
    public boolean isEqual(TypeDescription typeToCompare);

    /**
     * Retrieve the short description for this type, useful in logging and the like.
     * @return description
     */
    public String getDescription();

    /**
     * Retrieve the qualified name for the this type, necessary as an identifier
     * when registering jaxrpc type mappings
     * @return qualified name
     */
    public QName getQName();

}
