/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.transport.servicedescription;

import java.io.Serializable;

import eu.gemss.components.transport.servicedescription.policytypes.*;

/**
 * ServicePolicy provides information about the policy that should be enforced
 * when using a service
 */
public interface ServicePolicy extends Serializable {

    /**
     * Retrieve ordered list of policy item descriptors, order defines the order they
     * should be applied.
     * @return policy item descriptors
     */
    public PolicyTypeDescriptor[] getOrderedOutgoingPolicyTypes();


    /**
     * Retrieve ordered list of policy item descriptors, order defines the order they
     * should be applied
     * @return List of policy type descriptors
     */
    public PolicyTypeDescriptor[] getOrderedIncomingPolicyTypes();


    /**
     * Retrieve ordered list of policy items, order defines the order they should be
     * applied to an outgoing message
     * @return policy item list
     */
    public Policy[] getOrderedOutgoingPolicies();

    /**
     * Retrieve ordered list of policy items, order defines the order they should be applied
     * to an incoming message
     * @return policy item list
     */
    public Policy[] getOrderedIncomingPolicies();

}
