/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.transport.servicedescription.endpointtypes;

import java.io.Serializable;
import org.w3c.dom.Document;
import eu.gemss.components.transport.servicedescription.ServiceEndpoint;
import java.net.URL;

/**
 * WSDLEndpoint interface provides information about the endpoint / access point for a WSDL service
 */
public interface WSDLEndpoint extends ServiceEndpoint {

    /**
     * Retrieve the URI for the actual WSDL definition document
     * @return URI string
     */
    public String getWSDLURI();

    /**
     * Retrieve the WSDL document
     * @return WSDL document
     */
    public Document getWSDLDocument();

    /**
     * Set the WSDL document
     * @param document WSDL document
     */
    public void setWSDLDocument(Document document);

    /**
     * Retrieve the URL for endpoint / access point for the service
     * @return URL string
     */
    public URL getEndpointURL();

    /**
     * Set the endpoint URL
     * @param endpointURL endpoint URL
     */
    public void setEndpointURI(URL endpointURL);

    /**
     * Retrieve the service name
     * @return service name
     */
    public String getServiceName();

    /**
     * Set the service name
     * @param serviceName service name
     */
    public void setServiceName(String serviceName);

    /**
     * Retrieve the port name
     * @return port name
     */
    public String getPortName();

    /**
     * Set the port name
     * @param portName port name
     */
    public void setPortName(String portName);

    /**
     * Test to see if WSDL document is cached
     * @return true if cached, false otherwise
     */
    public boolean WSDLDocCached();


    /**
     * Test to see if endpoint set
     * @return true if set, false otherwise
     */
    public boolean endpointSet();

    /**
     * Test to see if WSDL uri set
     * @return true if set, false otherwise
     *
     */
    public boolean wsdlURISet();

    /**
     * Test to see if Service name has been set
     * @return true if set, false otherwise
     */
    public boolean serviceNameSet();

    /**
     * Test to see if port name has been set
     * @return true if set, false otherwise
     */
    public boolean portNameSet();
}
