/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.transport.servicedescription.interfacetypes;

/**
 * WSDL11TypeDescriptor describes the interface type for WSDL 1.1 defined within
 * the WSDL specification (http://www.w3c.org/...)
 */
public class WSDL11TypeDescriptor implements InterfaceTypeDescriptor {

    private static final String DESCRIPTION = "WSDL 1.1 Service Interface";

    /**
     * Retrieve a short string description for the type
     * @return description
     */
    public final String getDescription() {
        return DESCRIPTION;
    }

    /**
     * Check if this type matches the passed one
     * @param typeDesc identifier to check against
     * @return true if passed type is the same, false otherwise
     * @exception IllegalArgument If the passed type cannot be compared
     */
    public boolean isEqual(InterfaceTypeDescriptor typeDesc) {

        if(typeDesc.getClass().getName().equals(new WSDL11TypeDescriptor().getClass().getName()))
            return true;
        else
            return false;

    }
}