/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.components.transport.servicedescription.interfacetypes;

import org.w3c.dom.Document;
import eu.gemss.components.transport.servicedescription.ServiceInterface;
import eu.gemss.components.transport.servicedescription.ServiceDescriptionException;

/**
 * WSDLInterface interface provides information about the WSDL interface for a WSDL service
 */
public interface WSDLInterface extends ServiceInterface {

    /**
     * Retrieve the URI string for the WSDL definition document
     * @return URI string
     */
    public String getWSDLURI();

    /**
     * Retrieve the WSDL document
     * @return WSDL document
     */
    public Document getWSDLDocument() throws ServiceDescriptionException;

    /**
     * Retrieve the operation name required for the invocation
     * @return operation name
     */
    public String getOperationName();

    /**
     * Retrieve the binding required for the invocation
     * @return binding name
     */
    public String getWSDLBinding();

    /**
     * Test whether the service required uses RPC or Document SOAP
     * @return true if RPC service, false otherwise
     */
    public boolean isRPC();

    /**
     * Test to see if WSDL document is cached
     * @return true if cached, false otherwise
     */
    public boolean WSDLDocCached();

    /**
     * Set the WSDL Document
     * @param wsdlDoc WSDL Document
     */
    public void setWSDLDocument(org.w3c.dom.Document wsdlDoc);
}
