/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */

package eu.gemss.components.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipException;

/**
 * An interface to a collection of file archives.
 */
public interface Archive {

    /**
     * Opens the specified file as a zip archive.
     *
     * @param zipFile a <code>File</code> containing an archive in the 
     *      ZIP format.
     * @throws IOException if an I/O error occurs while opening the
     *      the specified file.
     * @throws FileNotFoundException if the specified file does not
     *      exist.
     */
    public ZipArchive openZipArchive( File zipFile ) 
            throws FileNotFoundException, IOException ;

    /**
     * Opens the file with the specified filename as a zip archive.
     *
     * @param zipFilename a <code>String</code> containing the name of a
     *      file in ZIP format.
     * @throws IOException if an I/O error occurs while opening the
     *      the specified file.
     * @throws FileNotFoundException if the specified file does not
     *      exist.
     */
    public ZipArchive openZipArchive( String zipFilename )
            throws FileNotFoundException, IOException ;

    /**
     * Creates a new file with the specified filename as a zip archive.
     *
     * @param zipFilename a <code>String</code> containing the name of the
     *      new archive file to create.
     * @throws IOException if an I/O error occurs while opening the
     *      the specified file.
     */
    public ZipArchiver createZipArchive( String zipFilename ) 
                                            throws IOException;

    /**
     * Creates a new file as a zip archive.
     *
     * @param zipFile a <code>File</code> for holding the
     *      new zip archive which is to be created.
     * @throws IOException if an I/O error occurs while opening the
     *      the specified file.
     */
    public ZipArchiver createZipArchive( File zipFile ) throws IOException;
}
