/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */

package eu.gemss.components.util;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;

/**
 * A simple interface for creating archives in using the ZIP format.
 */
public interface ZipArchiver {
    /**
     * Inserts the specified file into this archive. 
     * If the <code>File</code> object points to a
     * directory, then the directory will be transversed recursively
     * adding its contents to the archive.
     *
     * @param file a <code>File</code> to be placed in the archive.
     *      Any files in the archive with the same name 
     *      will be overwritten.
     * @throws IOException if an I/O error occurs.
     * @throws ZipException if any Zip file error occurs.
     */
    public void insert(  File file ) throws IOException, ZipException ;

    /**
     * Inserts the specified file into this archive. 
     * If the <code>File</code> object points to a
     * directory, then the directory will be transversed recursively
     * adding its contents to the archive.
     *
     * @param file a <code>File</code> to be placed in the archive.
     *      Any files in the archive with the same name 
     *      will be overwritten.
     * @param flatten if <code>true</code>, then any leading path information
     *      will be stripped from the file name before it is inserted into
     *      the archive.
     * @throws IOException if an I/O error occurs.
     * @throws ZipException if any Zip file error occurs.
     */
    public void insert(  File file , boolean flatten) 
                            throws IOException, ZipException ;

    /**
     * Inserts the specified files into this archive. 
     *      If any of any of the <code>File</code> objects point to
     *      directories, then the directories will be transversed recursively
     *      adding their contents to the archive.
     *
     * @param files an array of <code>File</code>s to be placed in the archive.
     *      Any files in the archive with the same name 
     *      will be overwritten.
     * @throws IOException if an I/O error occurs.
     * @throws ZipException if any Zip file error occurs.
     */
    public void insert(  File[] files ) throws IOException, ZipException ;

    /**
     * Inserts the specified files into this archive. 
     *      If any of any of the <code>File</code> objects point to
     *      directories, then the directories will be transversed recursively
     *      adding their contents to the archive.
     *
     * @param files an array of <code>File</code>s to be placed in the archive.
     *      Any files in the archive with the same name 
     *      will be overwritten.
     * @param flatten if <code>true</code>, then any leading path information
     *      will be stripped from the file name before it is inserted into
     *      the archive. The default is <code>false</code>.
     * @throws IOException if an I/O error occurs.
     * @throws ZipException if any Zip file error occurs.
     */
    public void insert(  File[] files , boolean flatten) 
                            throws IOException, ZipException ;

    /**
     * Close the archive. Once the archive is closed it cannot be changed.
     *
     * @throws IOException if an I/O error occurs.
     */
    public void close() throws IOException;

    /**
     * Retrive the name of this archive.
     *
     * @return a <code>String</code> containing the name of this archive file.
     */
    public String getName();
}
