/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 */

package eu.gemss.sandbox;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Policy;
import java.security.Provider;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CRL;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

/**
 * The sandbox constrains the actions of pluggable components.
 *
 */
public abstract class Sandbox {

    String name;
    String version;

    /**
     * Constructs a new <code>Sandbox</code> with the specified information.
     *
     * @param name a <code>String</code> containing the name of the sandbox
     *      provider
     * @param version a <code>String</code> containing version information.
     */
    protected Sandbox( String name, String version ){
        this.name = name;
        this.version = version;
    }

    /**
     * Retrieves the name of the sandbox provider.
     *
     * @return a <code>String</code> containing the name of the sandbox
     *      provider 
     */
    public String getName(){
        return name;
    }

    /**
     * Retrieves the version information for this implementation.
     *
     * @return a <code>String</code> containing the version information
     *      for this sandbox implementation.
     */
    public String getVersion(){
        return version;
    }

    /**
     * Initialize the sandbox.
     * 
     * @param caCerts the name of the directory or keystore containing trusted
     *      certificates. If the name is a directory it is assumed to contain
     *      trusted certificates, otherwise it is assumed to be a Java
     *      keystore.
     * @param crlDirName the name of the directory containing CRLs
     *      corresponding to the trusted certificates.
     * @throws IOException if an error occurs while reading in the
     *      certificates or CRLs
     * @throws GeneralSecurityException if an error occurs while processing
     *      the certificates or CRLs
     */
    public abstract void init( String caCerts, String crlDirName ) 
            throws IOException, GeneralSecurityException;
}
