/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 */

package eu.gemss.signals;

import eu.gemss.components.ComponentManager;

/**
 * A signal emitted whenever a component has been updated in the 
 * the component repository.
 */
public class ComponentUpdateSignal extends Signal {
    /**
     * The type of signal.
     */
    public static String SIGNAL_TYPE = "gemss.signal.ComponentUpdate";

    // the name of the component which was updated
    private String componentName;

    /**
     * The signal creator.
     *
     * @param source the {@link eu.gemss.components.ComponentManager} which
     *      issued this signal
     * @param componentName the fully qualified name of the component which
     *      was changed.
     */
    public ComponentUpdateSignal(ComponentManager source,
        								String componentName ) {
        super( source );
        this.componentName = componentName;
    }

    /**
    * Retrieve the name of the component which was updated. 
    *
    * @return a <tt>String</tt> identifying the component whose updating
    *       triggered this signal.
    */
    public String getComponentName() {
        return componentName;
    }

    /**
    * Retrieve the signal type.
    *
    * @return a <tt>String</tt> identifying this signal
    */
    public String getSignalType() {
        return SIGNAL_TYPE;
    }

}
