/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */

package eu.gemss.signals;

import java.util.EventObject;

/**
 * The base class for all signals emitted by any of the various components.
 * Generally, signals are mutable events used by components to request 
 * information from their environment, as well as sending notices to other
 * components. Signals are "round-trip" events, i.e., they are emitted by a
 * given component, processed by another component and then returned to their
 * original emitter.  If more than one component is listening for a particular
 * signal type, then the signal will be cloned and sent to each of the
 * listeners. Afterwards, the returned signals will be collated into an array
 * for return to the emitter.
 *
 */
public class Signal extends EventObject implements Cloneable {
    // The status of this signal tells us whether or not it has been
    // processed.
    private boolean status = false;

    /**
     * The type of signal.
     */
    public final static String SIGNAL_TYPE = "gemss.signal.Signal";

    /**
     * A public constructor.
     *
     * @param source An object identifying the source of the signal.
     */
    public Signal(Object source) {
        super( source );
    }

    /**
     * Retrieve the signal type. 
     * <p>
     * Subclasses should override this method
     * to return their signal type.
     *
     * @return a <tt>String</tt> representing the signal type.
     */
    public String getSignalType() {
        return SIGNAL_TYPE;
    }

    /**
     * Inquire as to whether or not this signal has been processed.
     *
     * @return <tt>true</tt> if the signal was processed.
     */
    public boolean wasProcessed() {
        return status;
    }

    /**
     * Sets the processed status of this signal.
     *
     */
    public void processed( ) {
        status = true;
    }

    /**
     * Clone this signal.
     *
     * @return an <tt>Signal</tt> which is a clone of this <tt>Signal</tt>.
     */
    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        } catch ( CloneNotSupportedException cnse ) {
            throw new RuntimeException( cnse );
        }
        return obj;
    }
}
