/*
 ************************************************************************
 *
 * Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
 *
 * Copyright in this software belongs to C&C Research Laboratories,
 * Rathausallee 10, 53757 Sankt Augustin, Germany.
 *
 * This software may not be used, sold, licensed, transferred, copied
 * or reproduced in whole or in part in any manner or form or in or
 * on any media by any person other than in accordance with the terms
 * of the Licence Agreement supplied with the software, or otherwise
 * without the prior written consent of the copyright owners.
 *
 * This software is distributed WITHOUT ANY WARRANTY, without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE, except where stated in the Licence Agreement supplied with
 * the software.
 *
 *  Created By :           G.A. Kohring
 *  Created for Project :  GEMSS (IST-2001-37153)
 *
 ************************************************************************
 *
 */

package eu.gemss.signals;

import java.security.BasicPermission;

/**
 * A class for holding signal permissions. Signal permissions
 * contain a name but no actions list; you either have the named 
 * permission or you don't.
 *
 * <P>
 * The currently supported signal permissions are:
 *
 * <table border=1 cellpadding=5 summary="permission target name, 
 *  what the target allows,and associated risks">
 * <tr>
 * <th>Permission Target Name</th>
 * <th>What the Permission Allows</th>
 * <th>Risks of Allowing this Permission</th>
 * </tr>
 *
 * <tr>
 *   <td>generate</td>
 *   <td>Generate Signals which are sent to other classes</td>
 *   <td>Granting this permission would allow
 * malicious applications to generate a credetial request signal
 * thereby gaining sensitive information.
 *  </td>
 * </>
 *
 * </table>
 *
 * @see java.security.Permissions
 *
 */
public final class SignalPermission extends BasicPermission {

    /**
     * Creates a new SignalPermission with the specified name.
     * The name is the symbolic name of the SignalPermission, such as
     * "generate".
     *
     * @param name the name of the SignalPermission.
     */

    public SignalPermission( String name ) {
	    super( name );
    }

    /**
     * Creates a new SignalPermission with the specified name.
     * The name is the symbolic name of the SignalPermission. The
     * actions String is currently unused.
     *
     * @param name the name of the RuntimePermission.
     * @param actions should be null.
     */

    public SignalPermission( String name, String actions ) {
        super( name, actions );
    }

}
