/************************************************************************
*
* Copyright (c) 2003-2004, C&C Research Laboratories, NEC Europe Ltd.
*
* Copyright in this library belongs to C&C Research Laboratories,
* Rathausallee 10, 53757 Sankt Augustin, Germany.
*
* This software may not be used, sold, licensed, transferred, copied
* or reproduced in whole or in part in any manner or form or in or
* on any media by any person other than in accordance with the terms
* of the Licence Agreement supplied with the software, or otherwise
* without the prior written consent of the copyright owners.
*
* This software is distributed WITHOUT ANY WARRANTY, without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
* PURPOSE, except where stated in the Licence Agreement supplied with
* the software.
*
*  Created By :           Federico Crazzolara
*  Created for Project :  GEMSS (IST-2001-37153)
*
************************************************************************/

package eu.gemss.signals.advsecurity;

import eu.gemss.signals.Signal;

public class AdvSecSignonSig extends Signal{

    public static final String SIGNAL_TYPE = "eu.gemss.signals.advsecurity.AdvSecSignonSig";

    private String password = null;
    private boolean wrong_pwd = false;
    private boolean wrong_keystore = false;

    public AdvSecSignonSig(Object source) {
	super(source);
    }

    public void setPassword(String pwd) {
	password = new String(pwd);
    }
    
    public String getPassword() {
	return password;
    }
    
    public void set_wrong_pwd(){
	wrong_pwd = true;
    }

    public void set_wrong_keystore(){
	wrong_keystore = true;
    }

    public boolean is_wrong_pwd(){
	return wrong_pwd;
    }
    
    public boolean is_wrong_keystore(){
	return wrong_keystore;
    }
    
    //required to override Signal base class method
    public String getSignalType() {
	return SIGNAL_TYPE;
    }
}
