/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.signals.negotiation;

import java.util.Hashtable;
import java.util.Vector;
import eu.gemss.signals.Signal;

/**
 * A signal for requesting acceptance of a WSLA contract
 */
public class AcceptContractRequest extends Signal {

      // request type
      public static final String SIGNAL_TYPE = "eu.gemss.signals.negotiation.AcceptContractRequest";
//      public static final String mstaticSignalType = SIGNAL_TYPE;

      // request data
      private String mstrWSLA;
      private String mstrSummary;
      private boolean mbAccept;
	  private int mnContracts;

      /**
       * Default constructor
       * @param source object that generated the request
       */
      public AcceptContractRequest( Object source )
      {
            super(source);

            // init
            mstrWSLA = "";
			mstrSummary = "";
			mbAccept = false;
      }

      /**
       * Sets the WSLA, ignoring null params
       * @param strWSLA WSLA object the the handler must accept or reject
       * @param strSummary summary string for this WSLA
       */
      public void setWSLA( String strWSLA, String strSummary )
      {
		  if( strWSLA != null ) mstrWSLA = strWSLA;
		  if( strSummary != null ) mstrSummary = strSummary;
      }

      /**
       * Retrieves the WSLA
       * @return the WSLA to accept or reject
       */
      public String getWSLA()
      {
            return mstrWSLA;
      }

      /**
       * Retrieves the WSLA summary
       * @return the WSLA summary
       */
      public String getSummary()
      {
            return mstrSummary;
      }

      /**
       * Sets the number of contracts "in hand" that would be checked if this contract were rejected.
       * @param nContracts number of contracts
       */
      public void setContracts( int nContracts )
      {
		  mnContracts = nContracts;
      }

      /**
       * Retrieves the number of contracts "in hand" that would be checked if this contract were rejected.
       * @return number of contracts
       */
      public int getContracts()
      {
            return mnContracts;
      }

      /**
       * Sets the accept flag
       * @param bAccept true if the handler accepts the WSLA contract
       */
      public void setAccept( boolean bAccept )
      {
		  mbAccept = bAccept;
      }

      /**
       * query accept flag
       * @return true if the handler accepts the WSLA (or false if not processed)
       */
      public boolean queryAccept()
      {
            return mbAccept;
      }

      /**
       * Return the signal type - override of the base class
       * @return Signal type
       */
      public String getSignalType()
      {
            return SIGNAL_TYPE;
      }
}