/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.signals.negotiation;

import java.util.Hashtable;
import java.util.Vector;
import eu.gemss.signals.Signal;

/**
 * A signal for requesting a service selection from a list of services.
 */
public class SelectSingleServiceRequest extends Signal {

      // request type
      public static final String SIGNAL_TYPE = "eu.gemss.signals.negotiation.SelectSingleServiceRequest";
//      public static final String mstaticSignalType = SIGNAL_TYPE;

      // request data
      private String mstrSelectedService;
      private Hashtable mhashServiceData;

      /**
       * Default constructor
       * @param source object that generated the request
       */
      public SelectSingleServiceRequest( Object source )
      {
            super(source);
            // init
            mhashServiceData = new Hashtable();
            mstrSelectedService = null;
      }


      /**
       * Sets selected service, using the WSDL URI as a key. Null indicates no selection.
       * @param strService The selected service WSDL URI, chosen from the list of services
       */
      public void setSelectedService( String strService )
      {
            if( strService != null ) {
                  mstrSelectedService = new String( strService );
            }
            else {
                  mstrSelectedService = null;
            }
      }

      /**
       * Retrieves the selected service
       * @return selected service name
       */
      public String getSelectedService()
      {
            return mstrSelectedService;
      }

      /**
       * Adds a new service to the lst of services
       * @param strWSDL WSDL string for this service
       * @param vectorServiceMetadata vector of strings that are associated with this service. This data may or may not be used to help make the choice of service.
       */
      public void addServiceToList( String strWSDL, Vector vectorServiceMetadata ) throws Exception
      {
            // add a clone of the vector to the list
            mhashServiceData.put( strWSDL,(Vector) vectorServiceMetadata.clone() );
      }

      /**
       * Returns the list of services. The list is a hashtable filled with WSDL strings for
       * keys and Vectors of strings for service metadata. The handler may or may not use the
       * metadata, but must use the WSDL URI as a key to the list.
       * @return Hashtable hash of WSDL strings (key) and vectors of strings (object)
       */
      public Hashtable getListOfServices()
      {
            return mhashServiceData;
      }

      /**
       * Return the signal type - override of the base class
       * @return Signal type
       */
      public String getSignalType()
      {
            return SIGNAL_TYPE;
      }
}