/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: ISS, NEC and IT Innovation jointly designed this
//      interface class as part of the GEMSS project design discussions.
//      The code itself was written by IT Innovation alone.
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package eu.gemss.signals.security;

/**
 * A signal for requesting authorization information from the user.
 *
 */
public class CredentialRequest extends eu.gemss.signals.Signal {

    public static final String SIGNAL_TYPE = "eu.gemss.signals.security.CredentialRequest";
//    public static final String CREDENTIAL_TYPE = SIGNAL_TYPE;

    private String mKeystorePath = null;

    private String mKeystorePassword = null;

    private String mPrivateKeyAlias = null;

    private String mPrivateKeyPassword = null;

    /**
    * Default constructor that takes no arguments.
    */
   public CredentialRequest(Object source) {
       super(source);
   }


   /**
    * Sets the keystore password
    * @param keystorePass password for keystore
    */
   public void setKeystorePassword(String keystorePass) {
       mKeystorePassword = new String(keystorePass);
   }

   /**
    * Retrieves the password for accessing the keystore
    * @return password
    */
   public String getKeystorePassword() {
       return mKeystorePassword;
   }

   /**
    * Sets the private key alias to be used by the security context component.
    * @param privateKeyAlias private key alias
    */
   public void setPrivateKeyAlias(String privateKeyAlias) {
       mPrivateKeyAlias = new String(privateKeyAlias);
   }

   /**
    * Retrieves the private key alias
    * @return private key alias
    */
   public String getPrivateKeyAlias() {
       return mPrivateKeyAlias;
   }

   /**
    * Sets the private key password for the given private key alias
    * @param privateKeyPassword private key password
    */
   public void setPrivateKeyPassword(String privateKeyPassword) {
       mPrivateKeyPassword = new String(privateKeyPassword);
   }

   /**
    * Retrieves the private key password
    * @return password for private key
    */
   public String getPrivateKeyPassword() {
       return mPrivateKeyPassword;

   }

   //required to override Signal base class method
   public String getSignalType() {
       return SIGNAL_TYPE;
    }
}
