/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.bindings.javarmi;

import java.rmi.*;

/*
 * class to provide a Java 1.3 binding to the GEMSS java code (which needs Java 1.4)
 */
public class GEMSS4Java13 {
	// flags
	public static final String FINISHED = GEMSSRMIProxy.FINISHED;
	public static final String NOT_FINISHED = GEMSSRMIProxy.NOT_FINISHED;
	public static final String NOT_STARTED = GEMSSRMIProxy.NOT_STARTED;
	public static final String FAILED = GEMSSRMIProxy.FAILED;

	// data and constants
	private static final String GEMMS4RMI_BINDING_NAME = "gemss4rmi";
	private GEMSSRMIProxy mGemssRMIProxy;

	/*
	* constructor
	* @param strConfigFile GEMSSProxy config filename
	*/
	public GEMSS4Java13( String strConfigFile ) throws GEMSSRMIProxyException {
		try{
			mGemssRMIProxy = (GEMSSRMIProxy) Naming.lookup(GEMMS4RMI_BINDING_NAME);
			mGemssRMIProxy.init( strConfigFile );
		}
		catch(java.rmi.RemoteException ex) {
			throw new GEMSSRMIProxyException(ex.getMessage());
		}
		catch(java.net.MalformedURLException ex) {
			throw new GEMSSRMIProxyException(ex.getMessage());
		}
		catch(java.rmi.NotBoundException ex) {
			throw new GEMSSRMIProxyException(ex.getMessage());
		}
	}

	/*
	* GEMSSProxy start method wrapper
	*/
	public void start() throws GEMSSRMIProxyException {
		try{
			mGemssRMIProxy.start();
		}
		catch(RemoteException ex) {
			throw new GEMSSRMIProxyException(ex.getMessage());
		}
	}

	/*
	* GEMSSProxy uploadData method wrapper
	* @param strInputFile input filename to upload to the server
	*/
	public void uploadData( String strInputFile ) throws GEMSSRMIProxyException {
		try{
			mGemssRMIProxy.uploadData( strInputFile );
		}
		catch(RemoteException ex) {
			throw new GEMSSRMIProxyException(ex.getMessage());
		}
	}

	/*
	* GEMSSProxy downloadData method wrapper
	* @param strFilename filename of file to download. If empty "" the output archive file will be downloaded.
	* @param strOutputFile filename for output file where downloaded file will be stored.
	*/
	public void downloadData( String strFilename, String strOutputFile ) throws GEMSSRMIProxyException {
		try{
			mGemssRMIProxy.downloadData( strFilename, strOutputFile );
		}
		catch(RemoteException ex) {
			throw new GEMSSRMIProxyException(ex.getMessage());
		}
	}

	/*
	* GEMSSProxy getStatus method wrapper
	* @return Status string as returned by the application specific monitor job script
	*/
	public String getStatus() throws GEMSSRMIProxyException {
		try{
			return mGemssRMIProxy.getStatus();
		}
		catch(RemoteException ex) {
			throw new GEMSSRMIProxyException(ex.getMessage());
		}
	}

	/*
	* GEMSSProxy kill method wrapper
	*/
	public void kill() throws GEMSSRMIProxyException {
		try{
			mGemssRMIProxy.kill();
		}
		catch(RemoteException ex) {
			throw new GEMSSRMIProxyException(ex.getMessage());
		}
	}

	/*
	* GEMSSProxy acknowledgeResults method wrapper
	*/
	public void acknowledgeResults() throws GEMSSRMIProxyException {
		try{
			mGemssRMIProxy.acknowledgeResults();
		}
		catch(RemoteException ex) {
			throw new GEMSSRMIProxyException(ex.getMessage());
		}
	}

	/*
	* GEMSSProxy getCId method wrapper
	* getCId will eventually be replaced by a negotiation step, but for phase two this must
	* be called before using the other proxy methods. See design for more details.
	* @return ID string returned by the service
	*/
	public String getJobCId() throws GEMSSRMIProxyException {
		try{
			return mGemssRMIProxy.getJobCId();
		}
		catch(RemoteException ex) {
			throw new GEMSSRMIProxyException(ex.getMessage());
		}
	}
}