/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.bindings.javarmi;

import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.util.Properties;
import java.io.FileInputStream;

public class GEMSS4RMI {

	// constants for the config property entries
	public static final String mstaticProxyConfigFile = "ProxyConfigFile";

	// private constants
	private static final String GEMMS4RMI_BINDING_NAME = "gemss4rmi";
	private static String mConfigFile;
	private static GEMSSRMIProxyImpl gemssImpl;

	/*
	* main
	* @param args Arguments from the command line. There should be two arguments, the "-configFile" label
	* and a filename to the config file. Incorrect arguments will print a help message and terminate.
	*/
	public static void main(String[] args)
	{
		org.w3c.dom.Document w3cRequestDesc;
		String strProxyConfigFile;
		Properties prop;

		try{
			//read in the configuration file name
			if(args.length!=2 || !args[0].equals("-configFile") ) {
				System.out.println("Command line incorrect, format should be: 'uk.ac.soton.itinnovation.gemss.bindings.javarmi.GEMSS4RMI -configFile <config-file-path>'");
				System.exit(1);
			}
			else {
				mConfigFile = args[1];
			}

			//add shutdown hook
			ShutdownThread shutdownHook = new ShutdownThread();
			Runtime.getRuntime().addShutdownHook(shutdownHook);

			// read the config file entries
			prop = new Properties();
			prop.load( new FileInputStream( mConfigFile ) );
			strProxyConfigFile = prop.getProperty( mstaticProxyConfigFile );

			// create an instance of the GEMSSProxyImpl implementation and initialize it
			gemssImpl = new GEMSSRMIProxyImpl();
			gemssImpl.init( strProxyConfigFile );

			// export its reference to the registry
			Naming.rebind( GEMMS4RMI_BINDING_NAME,gemssImpl );
		}
		catch(java.rmi.RemoteException ex) {
			System.out.println("Failed to set up the proxy object, reason: ");
			ex.printStackTrace();
			if(gemssImpl!=null) {
				gemssImpl.shutdown();
			}
			System.exit(1);
		}
		catch(Exception ex) {
			System.out.println("Failed, reason: ");
			if(gemssImpl!=null) {
				gemssImpl.shutdown();
			}
			System.exit(1);
		}
	}

	/*
	* shutdown thread
	*/
	static class ShutdownThread extends Thread {

		public ShutdownThread() {
			super();
		}

		/*
		* run to do the shutdown thing
		*/
		public void run() {
			try{
				System.out.println("[Shutdown thread] Shutting down");
				Naming.unbind(GEMMS4RMI_BINDING_NAME);
				//could do with a shutdown method or something
				if(gemssImpl!=null) {
					gemssImpl.shutdown();
				}
				System.out.println("[Shutdown thread] Shutdown complete");

			}
			catch(Exception ex) {
				System.out.println("[Shutdown thread] Shutdown incomplete");
				if(gemssImpl!=null) gemssImpl.shutdown();
			}
		}
	} // end of inline shutdown thread
} // end of GEMSS4RMI
