/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.bindings.javarmi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import org.w3c.dom.Document;

/*
 * interface to the GEMSS proxy
 */
public interface GEMSSRMIProxy extends Remote {

	// flags
	public final String FINISHED = "FINISHED";
	public final String NOT_FINISHED = "NOT_FINISHED";
	public final String FAILED = "FAILED";
	public final String NOT_STARTED = "NOT_STARTED";

	// methods
	public void init( String strConfigFile ) throws RemoteException;
	public void start() throws RemoteException;
	public void uploadData( String strInputFile ) throws RemoteException;
	public void downloadData( String strFilename, String strOutputFile ) throws RemoteException;
	public String getStatus() throws RemoteException;
	public void kill() throws RemoteException;
	public void acknowledgeResults() throws RemoteException;
	public String getJobCId() throws RemoteException;
}