/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.business;

import java.lang.*;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.*;
import java.io.*;

/**
 * Server side business module to handle pricing. A price model simply takes in a WSLA and
 * calculates a price for it. The exact pricing model is left to the extending class, since
 * this class is abstract in nature to provide the interface.
 */
public abstract class PriceModel {

      /**
       * calculates the price of a WSLA according to the pricing model's criertia. The price unit used is defined within the WSLA
       * and a conversion will take place if the price model unit's are different. If the WSLA unit is unknown then -1 will be
       * returned since no conversion is possible.
       * @param strWSLA string representation of a WSLA
       * @return price in the unit used by the WSLA
       */
      public abstract double calculatePrice( String strWSLA ) throws Exception;

} // end of PriceModel

