/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.negotiation;

import java.util.logging.Logger;
import java.util.logging.Level;
import java.io.*;

import uk.ac.soton.itinnovation.gemss.negotiation.QoSNegotiationImpl;
import eu.gemss.components.negotiation.QoSNegotiationRequest;
import eu.gemss.components.negotiation.QoSNegotiation;
import eu.gemss.components.providers.Provider;

/**
 * IT Innovation provider for the QoS negotiator component. Each call to create a
 * QoS negotiator will return a new instance.
 */
public class QoSNegotiationProvider implements Provider {

    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.negotiation.qosnegotiationprovider");
    private static final String QOS_NEGOTIATION_IDENTIFIER = "eu.gemss.components.negotiation.QoSNegotiation";
    private static final String COMPONENT_DESCRIPTION = "QoS Negotiation Component";
    private static final String QOS_NEGOTIATION_OWNER = "IT Innovation Centre";
    private static final boolean IS_LOCAL = true;
    private static final String VERSION = "0.1";

    /**
     * Default constructor takes no arguments so that it can be loaded easily
     * within the plug and play framework.
     */
    public QoSNegotiationProvider() {
    }

    /**
     * Creates an instance of the QoSNegotiation component (custom method not part of Provider). This will
     * create a new instance of the QoSNegotiation component regardless of how many already
     * exist.
     * @param strConfigFile QoS negotiation config file
     * @return instance of QoSNegotiation component, initialized with the parameters passed to this method
     */
    public QoSNegotiation createQoSNegotiation( String strConfigFile ) throws Exception
    {
	    QoSNegotiationImpl qosnegotiation;

	    try{
		    // create a new instance
		    qosnegotiation = new QoSNegotiationImpl();

		    // call the appropriate init method
                if( strConfigFile != null ) {
                      qosnegotiation.init( strConfigFile );
                }
                else throw new Exception("null qos negotiation config filename");

		    // return the negotiator
		    return qosnegotiation;
	    }
	    catch( Exception ex ) {
		    mLogger.log(Level.SEVERE,"QoSNegotiationProvider failed to create QoSNegotiationImpl",ex);
		    throw new Exception("QoSNegotiationProvider failed to create QoSNegotiationImpl (1) - see logs for details");
	    }
    }

    /**
     * Creates an instance of the QoSNegotiation component and initializes it.
     * @param serviceRequest service request where init info can be passed
     * @return instance of QoSNegotiation, initialized with the infromation contained in the service request.
     * If the service request is not of type QoSNegotiationRequest then no initialization will be done, and this
     * will be considered an error.
     */
    public Object createComponent( eu.gemss.components.ServiceRequest serviceRequest ) throws IOException
    {
	    QoSNegotiation negotiation;
	    QoSNegotiationRequest request;

	    try{
		    // set init parameters IF the right service request is used
		    if( serviceRequest instanceof QoSNegotiationRequest ) {
			    request = (QoSNegotiationRequest) serviceRequest;
                      // null config file is ok
                      negotiation = createQoSNegotiation( request.getConfigFile() );
		    }
		    else {
			    throw new Exception("null service request passed");
		    }

		    // return instance
		    return negotiation;
	    }
	    catch(Exception ex) {
		    mLogger.log(Level.SEVERE,"QoSNegotiationProvider failed to create QoSNegotiationImpl",ex);
		    throw new IOException("QoSNegotiationProvider failed to create QoSNegotiationImpl (2) - see logs for details");
	    }
    }

    /**
     * Creates an instance of the QoSNegotiation.
     * @return instance of QoSNegotiation, not initialized in any way - this
     * should be considered an error since a GEMSSNegotiator with no initialization is useless.
     */
    public Object createComponent() throws IOException {
	  try{
		  // create a new instance and do NOT call init
		  mLogger.log(Level.INFO,"No arguments passed to createComponent, QoSNegotiation not initialized");
		  return new QoSNegotiationImpl();
	  }
	  catch(Exception ex) {
		mLogger.log(Level.SEVERE,"QoSNegotiationProvider failed to create QoSNegotiationImpl",ex);
		throw new IOException("QoSNegotiationProvider failed to create QoSNegotiationImpl (3) - see logs for details");
	  }
    }

    public boolean supports(String identifier) {
        if(identifier.equals(QOS_NEGOTIATION_IDENTIFIER))
            return true;
        else
            return false;
    }

    public String getComponentName() {
        return QOS_NEGOTIATION_IDENTIFIER;

    }

    public String getProviderName() {
	  return QOS_NEGOTIATION_OWNER;

    }

    public String getDescription() {
        return COMPONENT_DESCRIPTION;
    }

    public boolean isLocal() {
        return IS_LOCAL;
    }

    public String getVersion() {
        return VERSION;
    }
}