/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.negotiation;

import eu.gemss.components.negotiation.QoSRequirements;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;

/**
 * This class implements the QoSRequirements interface. It provides a mechanism to describe weights and min/max
 * values associated with a set of QoS properties.
 */
public class QoSRequirementsImpl extends Object implements QoSRequirements {
      // member variables
      Hashtable mhashRequirements;

      /**
       * constructor
       */
      public QoSRequirementsImpl()
      {
            mhashRequirements = new Hashtable();
      }

      /**
       * destructor
       */
      protected void finalize() throws Throwable
      {
            Enumeration enum;
            Vector vector;

            // explicitly clear hash contents
            if( mhashRequirements != null ) {
                  enum = mhashRequirements.elements();
                  while( enum.hasMoreElements() ) {
                        vector = (Vector) enum.nextElement();
                        if( vector != null ) vector.clear();
                  }
                  mhashRequirements.clear();
            }
      } // finalize

      /**
       * Add a QoS property to the list. Each QoS parameter has a name and a set of properties.
       * Any exceptions will just flow straight through
       * While the vector could contain anything, for QoSNegotiationImpl (unit type, weight, min, max, constraint) is used, all strings.
       * @param strQoSParameterName name of the QoS parameter
       * @param vectorProperties vector of objects for this parameter. The object types can be defined by the user.
       */
      synchronized public void addQoSProperty( String strQoSParameterName, Vector vectorProperties ) throws Exception
      {
            // allow null vector but not null name
            if( strQoSParameterName == null ) throw new Exception("null QoS parameter name");

            // add to hash
            mhashRequirements.put( strQoSParameterName,vectorProperties );
      }

      /**
       * Returns the current set of QoS properties names and values.
       * While the vector could contain anything, for QoSNegotiationImpl [name,(unit type, weight, min, max, constraint)] is used, all strings.
       * Any exceptions will just flow straight through
       * @return hash table containing the QoSParameterName's as a key's, and property vector as contents
       */
      synchronized public Hashtable getQoSProperties() throws Exception
      {
            return mhashRequirements;
      }
} // QoSRequirenmentsImpl