/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.negotiation.auction;

import java.lang.*;
import java.io.*;

/*
 * AuctionMessageBody class implementation. This class extends String to provide a transport neutral mechanism
 * to represent the content of the auction messages. Content is message type dependant, but normally details the
 * substance of the negotiation such as a specific bid's details.
*/
public class AuctionMessageBody extends Object implements Serializable
{
      // string body data encoded as a string
      private String mstrBody;

	/**
	* constructor
	* @param strContent A string representation of the message content. The language / syntax of this content if
	* defined within the header object that is passed with this message body.
	*/
	public AuctionMessageBody( String strContent ) {
            super();
		mstrBody = strContent;
	}

      /**
      * Return the value of the body encoded as a string
      * defined within the header object that is passed with this message body.
      * @return string containing the body
      */
      public String toString() {
            return mstrBody;
      }

} // end of AuctionMessageBody
