/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.negotiation.auction;

import java.lang.*;
import java.io.*;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * AuctionMessageHeader class implementation. This class contains fields for all the attributes that the basic
 * FIPA message contains. The FIPA syntax is hidden from the caller by this class.
*/
public class AuctionMessageHeader extends Object implements Serializable {

	// header fields for auction messages
	private String mstrConversationID;
	private String mstrLanguage;
	private String mstrOntology;
	private String mstrSenderID;
	private String mstrReceiverID;

	// logger variable
	static private Logger mlogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.negotiation.auction.auctionmessageheader");

	/**
	 * AuctionMessageHeader constructor
	 * @param strConversationID conversation ID
	 * @param strLanguage name of the language used by teh body e.g. XML
	 * @param strOntology URI of the ontology used, if any, by the message body
	 * @param strSenderID ID of the sender of the message
	 * @param strReceiverID ID of the receiver of the message
	 */
	public AuctionMessageHeader( String strConversationID, String strLanguage,
								String strOntology, String strSenderID, String strReceiverID ) throws Exception
	{
		super();

		try
		{
			// set fields
			mstrConversationID = strConversationID;
			mstrLanguage = strLanguage;
			mstrOntology = strOntology;
			mstrSenderID = strSenderID;
			mstrReceiverID = strReceiverID;

			// all done
			return;
		}
		catch ( Exception ex )
		{
			mlogger.log( Level.SEVERE,"Exception during construction",ex);
			throw new Exception("constructor failed: "+ex.getMessage()+" - see java Logger log for full details");
		}
	}

	/* return the value of the conversation ID header field @return conversation ID */
	public String getConversationID() { return mstrConversationID; }
	/* return the value of the language header field @return name of the language e.g. XML used by the message body*/
	public String getLanguage() { return mstrLanguage; }
	/* return the value of the ontology header field @return principle ontology URI used by the message body (if any)*/
	public String getOntology() { return mstrOntology; }
	/* return the value of the sender ID header field @return sender ID*/
	public String getSenderID() { return mstrSenderID; }
	/* return the value of the receiver ID header field @return receiver ID*/
	public String getReceiverID() { return mstrReceiverID; }

} // end of AuctionMessageHeader
