/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.negotiation.evaluator;

import java.lang.*;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.*;
import java.io.*;

import uk.ac.soton.itinnovation.gemss.negotiation.CallForProposalsXML;

/**
 * abstract class to present an interface to a WSLA QoS property evaluator class. This class takes
 * a QoS property vector and computes a score for it. This score will be used by the client to judge
 * which WSLA to choose from the set of WSLA's generated by each service provider. An abstract and
 * concrete class has been created for the QoSEvaluator to allow easy implementation of different
 * evaluation strategies.
 */
public interface QoSEvaluator {

      /**
       * calculate a score for a QoS property vector
       * @param hashValues hash of QoS property values obtained from a WSLA [prop name, vector(unit uri, type uri, value)]
       * @param call call for proposals with properties, weights and min/max values
       * @return score between 0 and 1. 1 is highest and 0 is lowest.
       */
      public abstract double calculateScore( Hashtable hashValues, CallForProposalsXML call ) throws Exception;

      /**
       * satisfy a threshold score value given a call and a WSLA template. A new WSLA is produced containing values that satisfy the
       * threshold value. If the threshold cannot be met null is returned.
       * @param strWSLATemplate WSLA template, needed to invoke the business module to get a price
       * @param call call for proposals with properties, weights and min/max values
       * @return WSLA string or null if could not satisfy threshold value
       */
      public abstract String satisfyThreshold( String strWSLATemplate, CallForProposalsXML call, double nThreshold ) throws Exception;

} // end of QoSEvaluator

