/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.negotiation.owl;

import java.lang.*;
import java.util.Vector;

/*
* Interface for an OWL individual handler that will allow inspection fo the instances held within
* an OWL ontology. The OWL model is initially loaded, and then property values can be requested etc.
*/
public interface OWLIndividualHandler {

      /**
       * load an OWL ontology from a given URI.
       * @param strURI ontology URI from where the OWL ontology can be read
       */
      public void loadOntology( String strURI ) throws Exception;

      /**
       * load an OWL ontology from a given URI.
       * @param strURI ontology URI from where the OWL ontology can be read
       * @param strAlternativeURI An alternative URI, such as a local file, for the ontology URI.
       * This URI will be opened, read, and treated as if the original URI has been read.
       */
      public void loadOntology( String strURI, String strAlternativeURI ) throws Exception;

      /**
       * list the properties associated with an individual, within the context of the
       * loaded ontology
       * @param strURI URI pointing to an OWL individual
       * @return vector of property names (strings) for this individual, or null is there are none
       */
      public Vector listProperties( String strURI ) throws Exception;

      /**
       * get the property name for a specific individual, within the context of the
       * loaded ontology
       * @param strURI URI pointing to an OWL individual
       * @param strProperty name of the property
       * @return string representing the value of the property, or null if no value was obtainable
       */
      public String getPropertyValue( String strURI, String strProperty ) throws Exception;

} // end of OWLIndividualHandler