/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.negotiation.wsla;

import java.lang.*;
import java.util.Hashtable;
import java.util.Vector;

/*
 * WSLA parse and formatter, designed to work specifically on the SLA parameters refering to
 * quality of service parameters. Heavily uses the JAXP XML parsing code.
*/
public interface WSLAQoSHandler {

      /**
       * parses a WSLA string and extracts all SLA parameters in the service definition section
       * of the WSLA. The result is a list of SLA properties, and associated with this list
       * are type URI's, unit URI's and values (from obligations section) for the properties.
       * @param strWSLA string representation of the WSLA document
       * @return hashtable containing (propery URI, vector). The vector contains (unit, type, value) strings.
       */
      public Hashtable parseSLAParameters( String strWSLA ) throws Exception;

      /**
       * parses a WSLA string and sets all SLA parameter values. Values are set in the obligations section.
       * @param strWSLA string representation of the WSLA document
       * @param hashValues hashtable containing (propery URI, vector). The vector contains (name, unit, type, value) strings.
       * @return new WSLA string containign the new values
       */
      public String setSLAValues( String strWSLA, Hashtable hashSLAValues ) throws Exception;

      /**
       * parses a WSLA string and extracts the service definition validity dates
       * of the WSLA. Start, End and Months are extracted.
       * @param strWSLA string representation of the WSLA document
       * @return vector containing (start, end) validity parameters for this WSLA.
       */
      public Vector parseValidity( String strWSLA ) throws Exception;

      /**
       * parses a WSLA string and sets all validity dates. Only one validity date is used throughout the contract, so obligation validity
       * fields are set along with teh service definition dates. If more fine grained control is needed, then another method would need
       * to be written to do this.
       * @param strWSLA string representation of the WSLA document
       * @param vectorValidity vector containing (start, end) validity parameters for this WSLA.
       * @return new WSLA string containing the new values
       */
      public String setValidity( String strWSLA, Vector vectorValidity ) throws Exception;

	/**
	 * validates a WSLA string against another template WSLA string. Everything is checked for
	 * an exact match except for the parameter values.
	 * @param strWSLA string representation of the WSLA document
	 * @param strWSLATemplate string representation of the WSLA template
	 * @return true if the WSLA matches the format of the template
	 */
	public boolean validateWSLA( String strWSLA, String strWSLATemplate ) throws Exception;

} // end of WSLAQoSHandler
