/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.proxies;

import java.util.logging.Logger;
import java.util.logging.Level;
import java.io.*;

import uk.ac.soton.itinnovation.gemss.proxies.*;
import eu.gemss.components.proxies.*;
import eu.gemss.components.providers.*;

/**
 * IT Innovation provider for the gemss negotiator component. Each call to create a GEMSS
 * negotiator will return a new instance.
 */
public class GEMSSNegotiatorProvider implements Provider {

    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.proxies.gemssnegotiator");
    private static final String GEMSS_NEGOTIATOR_IDENTIFIER = "eu.gemss.components.proxies.GEMSSNegotiator";
    private static final String COMPONENT_DESCRIPTION = "GEMSS Negotiator Component";
    private static final String GEMSS_NEGOTIATOR_OWNER = "IT Innovation Centre";
    private static final boolean IS_LOCAL = true;
    private static final String VERSION = "0.1";

    /**
     * Default constructor takes no arguments so that it can be loaded easily
     * within the plug and play framework.
     */
    public GEMSSNegotiatorProvider() {
    }

    /**
     * Creates an instance of the GEMSSNegotiator (custom method not part of Provider). This will
     * create a new instance of the GEMSSNegotiator component regardless of how many already
     * exist.
     * @param strRequestDescFilename filename of the application specific description of the input data characteristics.
     * @param strServiceName name of the service required
     * @param strQoSConfigFile QoSNegotiation config file
     * @param strProxyConfigFile GEMSSProxy config file containign end point etc (can be null to trigger service discovery)
     * @return instance of GEMSSProxy, initialized with the parameters passed to this method
     */
    public GEMSSNegotiator createGEMSSNegotiator( String strRequestDescFilename, String strServiceName, String strQoSConfigFile, String strProxyConfigFile ) throws Exception
    {
	    GEMSSNegotiatorImp negotiator;

	    try{
		    //create a new instance
		    negotiator = new GEMSSNegotiatorImp();

		    // call the appropriate init method
                negotiator.init( strRequestDescFilename, strServiceName, strQoSConfigFile, strProxyConfigFile );

		    // return the negotiator
		    return negotiator;
	    }
	    catch( Exception ex ) {
		    mLogger.log(Level.SEVERE,"GEMSSNegotiatorProvider failed to create GEMSSNegotiatorImp",ex);
		    throw new Exception("GEMSSNegotiatorProvider failed to create GEMSSNegotiatorImp");
	    }
    }

    /**
     * Creates an instance of the GEMSSNegotiator and initializes it.
     * @param serviceRequest service request where init info can be passed
     * @return instance of GEMSSNegotiator, initialized with the infromation contained in the service request.
     * If the service request is not of type GEMSSNegotiatorRequest then no initialization will be done, and this
     * will be considered an error.
     */
    public Object createComponent( eu.gemss.components.ServiceRequest serviceRequest ) throws IOException
    {
	    GEMSSNegotiator negotiator;
	    GEMSSNegotiatorRequest request;

	    try{
		    // set init parameters IF the right service request is used
		    if( serviceRequest instanceof GEMSSNegotiatorRequest ) {
			    request = (GEMSSNegotiatorRequest) serviceRequest;
                      // null config file is ok
                      negotiator = createGEMSSNegotiator( request.getRequestDesc(),request.getServiceName(), request.getQoSConfigFile(), request.getProxyConfigFile() );
		    }
		    else {
			    throw new Exception("null service request passed");
		    }

		    // create a new instance and do NOT call init
		    return negotiator;
	    }
	    catch(Exception ex) {
		    mLogger.log(Level.SEVERE,"GEMSSNegotiatorProvider failed to create GEMSSNegotiatorImp",ex);
		    throw new IOException("GEMSSNegotiatorProvider failed to create GEMSSNegotiatorImp");
	    }
    }

    /**
     * Creates an instance of the GEMSSNegotiator.
     * @return instance of GEMSSNegotiator, not initialized in any way - this
     * should be considered an error since a GEMSSNegotiator with no initialization is useless.
     */
    public Object createComponent() throws IOException {
	  try{
		  // create a new instance and do NOT call init
		  mLogger.log(Level.SEVERE,"No arguments passed to createComponent, GEMSSNegotiator not initialized - this is an error (use a request object)");
		  return new GEMSSNegotiatorImp();
	  }
	  catch(Exception ex) {
		mLogger.log(Level.SEVERE,"GEMSSNegotiatorProvider failed to create GEMSSNegotiatorImp",ex);
		throw new IOException("GEMSSNegotiatorProvider failed to create GEMSSNegotiatorImp");
	  }
    }

    public boolean supports(String identifier) {
        if(identifier.equals(GEMSS_NEGOTIATOR_IDENTIFIER))
            return true;
        else
            return false;
    }

    public String getComponentName() {
        return GEMSS_NEGOTIATOR_IDENTIFIER;

    }

    public String getProviderName() {
	  return GEMSS_NEGOTIATOR_OWNER;

    }

    public String getDescription() {
        return COMPONENT_DESCRIPTION;
    }

    public boolean isLocal() {
        return IS_LOCAL;
    }

    public String getVersion() {
        return VERSION;
    }
}