/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.proxies;

import java.util.logging.Logger;
import java.util.logging.Level;
import java.io.*;

import uk.ac.soton.itinnovation.gemss.proxies.*;
import eu.gemss.components.*;
import eu.gemss.components.proxies.*;
import eu.gemss.components.providers.*;

/**
 * IT Innovation provider for the WebServiceInvoker utility component. This creates a single
 * instance of the web service invoker, which will be returned to all components that want
 * to use it. Methods are synchronized to allow asynchronous access.
 */
public class WebServiceInvokerProvider implements Provider {

    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.proxies.webserviceinvokerprovider");
    private static final String WEB_PROXY_IDENTIFIER = "eu.gemss.components.proxies.WebServiceInvoker";
    private static final String COMPONENT_DESCRIPTION = "Web Service Invoker Component";
    private static final String WEB_PROXY_OWNER = "IT Innovation Centre";
    private static final boolean IS_LOCAL = true;
    private static final String VERSION = "0.1";
    private static WebServiceInvoker mstaticInvoker = null;

    /**
     * Default constructor takes no arguments so that it can be loaded easily
     * within the plug and play framework
     */
    public WebServiceInvokerProvider() {
    }

    /**
     * Returns an instance of the WebServiceInvoker
     * @return instance of WebServiceInvoker
     */
    public Object createComponent() throws IOException {
        try{
            //create a new WebServiceInvoker
            if( mstaticInvoker == null ) {
                mstaticInvoker = new WebServiceInvokerImp();
            }
            return mstaticInvoker;
        }
        catch(Exception ex) {
            mLogger.log(Level.SEVERE,"WebServiceInvokerProvider failed to create WebServiceInvokerImp",ex);
            throw new IOException("WebServiceInvokerProvider failed to create WebServiceInvokerImp");
        }
    }

    /**
     * Returns an instance of the WebServiceInvoker
     * @param serviceRequest request object which is ignored by this provider
     * @return instance of WebServiceInvoker
     */
    public Object createComponent( eu.gemss.components.ServiceRequest serviceRequest ) throws IOException {
	  try{
		//create a new WebServiceInvoker
		if( mstaticInvoker == null ) {
		    mstaticInvoker = new WebServiceInvokerImp();
		}
		return mstaticInvoker;
	  }
	  catch(Exception ex) {
		mLogger.log(Level.SEVERE,"WebServiceInvokerProvider failed to create WebServiceInvokerImp",ex);
		throw new IOException("WebServiceInvokerProvider failed to create WebServiceInvokerImp");
	  }
    }

    public boolean supports(String identifier) {
        if(identifier.equals(WEB_PROXY_IDENTIFIER))
            return true;
        else
            return false;
    }

    public String getComponentName() {
        return WEB_PROXY_IDENTIFIER;

    }

    public String getProviderName() {
	  return WEB_PROXY_OWNER;

    }

    public String getDescription() {
        return COMPONENT_DESCRIPTION;
    }

    public boolean isLocal() {
        return IS_LOCAL;
    }

    public String getVersion() {
        return VERSION;
    }
}