/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.security.context.configuration;

import java.util.logging.Logger;
import java.util.logging.Level;

import uk.ac.soton.itinnovation.gemss.utils.configuration.ConfigurationException;
import uk.ac.soton.itinnovation.gemss.utils.configuration.Configuration;
import uk.ac.soton.itinnovation.gemss.security.context.configuration.*;
import eu.gemss.components.security.SecurityConfigurationException;

public class SecurityProviderConfiguration implements eu.gemss.components.security.SecurityProviderConfiguration {

    SecurityContextConfiguration mConfiguration;

    public SecurityProviderConfiguration(SecurityContextConfiguration ctxConfiguration) {
        mConfiguration = ctxConfiguration;
    }

    /**
     * Retrieve the configuration value for the passed configuration option name
     * @param name name of option to retrieve
     * @return configuration option value
     * @throws ConfigurationException
     */
    public String getConfigurationValue(String name) throws SecurityConfigurationException {
        try{
            return mConfiguration.getConfigurationValue(name);
        }
        catch(ConfigurationException ex) {
            throw new SecurityConfigurationException(ex.getMessage());
        }
    }

    /**
     * Add a configuration option to the active configuration, no overwriting is allowed
     * @param name configuration option name
     * @param value configuration option value
     * @throws ConfigurationException
     */
    public void addConfigurationSetting(String name, String value) throws SecurityConfigurationException {
        try {
            mConfiguration.addConfigurationSetting(name,value);
        }
        catch(ConfigurationException ex) {
            throw new SecurityConfigurationException(ex.getMessage());
        }
    }

    /**
     * Retrieve the configuration directory for the security module
     * @return configuration directory
     */
    public String getConfigurationDir() {
        return mConfiguration.getConfigDirectory();
    }
}