/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.security.context.proxies.gemss;

//import eu.gemss.components.providers.SecurityContextProvider;
import eu.gemss.components.security.GEMSSSecurityContext;
import eu.gemss.components.ServiceRequest;
import eu.gemss.components.providers.*;

import java.util.logging.Logger;
import java.util.logging.Level;
import java.io.*;

/**
 * IT Innovation provider for the standard security context module
 */
public class SecurityContextComponentProvider implements Provider {

    private static Logger mLogger = Logger.getLogger("uk.ac.soton.itinnovation.gemss.security.context.proxies.gemss.SecurityContextComponentProvider");
    private static final String SECURITY_CONTEXT_IDENTIFIER = "eu.gemss.components.security.GEMSSSecurityContext";
    private static final String SECURITY_CONTEXT_OWNER = "IT Innovation Centre";
    private static final String COMPONENT_DESCRIPTION = "Security Context Component";
    private static final boolean IS_LOCAL = true;
    private static final String VERSION = "0.1";
    private static GEMSSSecurityContext mComponentInstance = null;


    /**
     * Default constructor takes no arguments so that it can be loaded easily
     * within the plug and play framework
     */
    public SecurityContextComponentProvider() {}


    /**
     * Creates an instance of the SecurityContextComponent
     * @return instance of security context component
     */
    public GEMSSSecurityContext createSecurityContext() throws eu.gemss.components.security.SecurityContextException {
        try{
            //create a new GEMSSSecurityContextModule
            if(mComponentInstance==null)
                //create a new instance
                mComponentInstance = new GEMSSSecurityContextImpl();
            return mComponentInstance;
        }
        catch(Exception ex) {
            mLogger.log(Level.SEVERE,"Unexpected failure occured inside security context component, please send a bug report including all log files",ex);
            throw new eu.gemss.components.security.SecurityContextException("Unexpected failure occured inside security context component, please send a bug report including all log files");
        }
    }

    public Object createComponent( ServiceRequest request ) throws IOException {
	    return createComponent();
    }

    public Object createComponent() throws IOException {
        try{
            //create a new GEMSSSecurityContextModule
            if(mComponentInstance==null)
                //create a new instance
                mComponentInstance = new GEMSSSecurityContextImpl();
            return mComponentInstance;
        }
        catch(Exception ex) {
            mLogger.log(Level.SEVERE,"Unexpected failure occured inside security context component, please send a bug report including all log files",ex);
            throw new IOException("Unexpected failure occured inside security context component, please send a bug report including all log files");
        }
    }

    public boolean supports(String identifier) {
        if(identifier.equals(SECURITY_CONTEXT_IDENTIFIER))
            return true;
        else
            return false;
    }

    public String getComponentName() {
        return SECURITY_CONTEXT_IDENTIFIER;
    }

    public String getProviderName() {
	  return SECURITY_CONTEXT_OWNER;
    }

    public String getDescription() {
        return COMPONENT_DESCRIPTION;
    }

    public boolean isLocal() {
        return IS_LOCAL;
    }

    public String getVersion() {
        return VERSION;
    }
}