/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.security.context.token.providers.javakeystore;

public class KeystoreCredentials {

    private String mKeystorePath;
    private String mKeystorePassword;
    private String mPrivateKeyAlias;
    private String mPrivateKeyPassword;

    /**
     * Constructor takes all required credentials, and is then immutable
     * @ param keystorePat path to keystore
     * @ param keystorePassword password for keystore
     * @ param privateKeyAlias alias for the principal
     * @ param privateKeyPassword password needed to retrieve Private Key for the alias.
     */
    public KeystoreCredentials(String keystorePath,
                                String keystorePassword,
                                String privateKeyAlias,
                                String privateKeyPassword) throws KeyManagerException {
        if(keystorePath!=null && !keystorePath.equals(""))
            mKeystorePath = keystorePath;
        else
            throw new KeyManagerException("Keystore path is invalid");
        if(keystorePassword!=null && !keystorePath.equals("")) {
            mKeystorePassword = keystorePassword;
        }
        else
            throw new KeyManagerException("Keystore password is invalid");
        if(privateKeyAlias!=null && !privateKeyAlias.equals(""))
            mPrivateKeyAlias = privateKeyAlias;
        else
            throw new KeyManagerException("Private key alias is invalid");
        if(privateKeyPassword!=null && !privateKeyPassword.equals(""))
            mPrivateKeyPassword = privateKeyPassword;
        else
            throw new KeyManagerException("Private key password is invalid");
    }

    /**
     * Retrieve the keystore path
     * @return keystore path
     */
    public String getKeystorePath() {
        return mKeystorePath;
    }

    /**
     * Retrieve the keystore password
     * @return keystore password
     */
    public String getKeystorePassword() {
        return mKeystorePassword;
    }

    /**
     * Retrieve the private key alias
     * @return private key alias
     */
    public String getPrivateKeyAlias() {
        return mPrivateKeyAlias;
    }

    /**
     * Retrieve the private key password
     * @return private key password
     */
    public String getPrivateKeyPassword() {
        return mPrivateKeyPassword;
    }

}
