/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.security.context.token.types;

import java.security.PrivateKey;

import eu.gemss.components.security.token.types.key.asymmetric.AsymmetricKeyDescriptor;
import eu.gemss.components.security.token.TokenDescriptor;
import eu.gemss.components.security.token.types.key.asymmetric.PrivateKeyToken;
import eu.gemss.components.security.token.types.UnsupportedTokenException;


public class PrivateKeyTokenImpl implements PrivateKeyToken {

    private AsymmetricKeyDescriptor mDescriptor;
    private PrivateKey mPrivateKey;


    public PrivateKeyTokenImpl(PrivateKey pKey) throws UnsupportedTokenException {
    	this.mPrivateKey = pKey;

        if(pKey.getAlgorithm().equals("RSA"))
            this.mDescriptor = new AsymmetricKeyDescriptor(AsymmetricKeyDescriptor.PRIVATE_KEY, AsymmetricKeyDescriptor.CYPHER_ALGO_RSA);
        else if(pKey.getAlgorithm().equals("DSA"))
            this.mDescriptor = new AsymmetricKeyDescriptor(AsymmetricKeyDescriptor.PRIVATE_KEY, AsymmetricKeyDescriptor.CYPHER_ALGO_DSA);
        else
            throw new UnsupportedTokenException("Loaded private key has unrecognised algorithm type");

    }

    /**
     * Retrieve the token descriptor for this security token
     * @return token descriptor
     */
    public TokenDescriptor getTokenDescriptor() {
        return mDescriptor;
    }

    /**
     * Retrieve the encoding format for this key
     * @return format
     */
    public String getEncodingFormat() {
        return mPrivateKey.getFormat();
    }

    /**
     * Retrieve the encoded form of the key
     * @return encoded key
     */
    public byte[] getEncoded() {
        return mPrivateKey.getEncoded();
    }

    /**
     * Retrieve the private key object
     * @return private key
     */
    public PrivateKey getKey() {
    	return mPrivateKey;
    }

}