/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.security.context.token.types;

import java.security.cert.X509Certificate;
import eu.gemss.components.security.token.SecurityTokenException;
import eu.gemss.components.security.token.TokenDescriptor;
import eu.gemss.components.security.token.types.pki.X509CertificateChainToken;
import eu.gemss.components.security.token.types.pki.X509CertificateChainDescriptor;


/**
 * X509CerificateChainTokenType is a concrete implementation of a type of SecurityToken.
 *
 */
public class X509CertificateChainTokenImpl implements X509CertificateChainToken {

    public static final String AUTH_TYPE_RSA = "RSA";

    private static final String mDescription = "X509 Certificate Chain";
    private X509Certificate[] mChain = null;
    private X509CertificateChainDescriptor mCertChainDesc = null;
    private String mAuthType = null;

    /**
     * Constructor creates a default Certificate Chain that will use RSA
     */
    public X509CertificateChainTokenImpl(X509Certificate[] chain, String authType, boolean accepted) {
        //assuming they are all X509 certificates
        //going to deep copy just in case
        mChain = new X509Certificate[chain.length];
        for(int i=0;i<chain.length;i++) {
            mChain[i] = chain[i];
        }
        mCertChainDesc = new X509CertificateChainDescriptor(accepted);
        mAuthType = authType;
    }

    /**
     * Retrieve the token descriptor for this token
     * @return token descriptor
     * @throws SecurityTokenException
     */
    public eu.gemss.components.security.token.TokenDescriptor getTokenDescriptor() throws SecurityTokenException {
        return mCertChainDesc;
    }
    /**
     * Retrieve a certificate chain
     * @return chain
     */
    public X509Certificate[] getX509CertificateChain() {
        return mChain;
    }

    public final String getDescription() {
        return mDescription;
    }

    /**
     * Retrieve authentication type based on the server certificate
     * @return authType
     */
    public String getAuthType() {
        return mAuthType;
    }

}


