/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Darren Marvin
//      Created date:           2004/04/30
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.security.context.token.types;

import java.security.cert.X509Certificate;

import eu.gemss.components.security.token.SecurityTokenException;
import eu.gemss.components.security.token.types.pki.X509CertificateToken;
import eu.gemss.components.security.token.types.key.asymmetric.PublicKeyToken;
import eu.gemss.components.security.token.types.pki.CertificateDescriptor;
import eu.gemss.components.security.token.types.key.asymmetric.AsymmetricKeyDescriptor;
import eu.gemss.components.security.token.types.UnsupportedTokenException;

public class X509CertificateTokenImpl implements X509CertificateToken {

    private CertificateDescriptor mCertDesc;
    private PublicKeyTokenImpl mPubKeyToken;
    private X509Certificate mCert;

    public X509CertificateTokenImpl(X509Certificate cert) throws UnsupportedTokenException{
        mCert = cert;
        mPubKeyToken = new PublicKeyTokenImpl(mCert.getPublicKey());
        mCertDesc = new CertificateDescriptor(CertificateDescriptor.PKI_X509V3, ((AsymmetricKeyDescriptor) mPubKeyToken.getTokenDescriptor()).getCypherAlg());
    }

    /**
     * Retrieve the public key token for this certificate
     * @return public key token
     */
    public PublicKeyToken getPublicKeyToken() throws SecurityTokenException {
        return mPubKeyToken;
    }

    /**
     * Retrieve the certificate encoded as byte array
     * @return encoded data
     * @throws SecurityTokenException
     */
    public byte[] getEncoded() throws SecurityTokenException {
        try{
            return mCert.getEncoded();
        }
        catch(java.security.cert.CertificateEncodingException ex) {
            throw new SecurityTokenException(ex.getMessage());
        }
    }

    /**
     * Retrieve the token descriptor for this token
     * @return token descriptor
     * @throws SecurityTokenException
     */
    public eu.gemss.components.security.token.TokenDescriptor getTokenDescriptor() throws SecurityTokenException {
        return mCertDesc;
    }

    /**
     * Retrieve the issuer Distinguished Name
     * @return issuer DN
     * @throws SecurityTokenException
     */
    public String getIssuerDN() throws SecurityTokenException {
        return mCert.getIssuerDN().toString();
    }

    /**
     * Retrieve the subject Distinguished Name
     * @return subject DN
     * @throws SecurityTokenException
     */
    public String getSubjectDN() throws SecurityTokenException {
        return mCert.getSubjectDN().toString();
    }

    /**
     * Retrieve the X509Certificate for this certificate token
     * @return certificate X509 certificate
     */
    public X509Certificate getX509Certificate() throws SecurityTokenException {
        return mCert;

    }

}