/////////////////////////////////////////////////////////////////////////
//
//  University of Southampton IT Innovation Centre, 2004
//
// Copyright in this library belongs to the IT Innovation Centre of
// 2 Venture Road, Chilworth Science Park, Southampton, SO16 7NP, UK.
//
// This software may not be used, sold, licensed, transferred, copied
// or reproduced in whole or in part in any manner or form or in or
// on any media by any person other than in accordance with the terms
// of the Licence Agreement supplied with the software, or otherwise
// without the prior written consent of the copyright owners.
//
// This software is distributed WITHOUT ANY WARRANTY, without even the
// implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
// PURPOSE, except where stated in the Licence Agreement supplied with
// the software.
//
//      Created by:             Stuart E. Middleton
//      Created date:           2004/06/08
//      Created for project:    GEMSS
//
/////////////////////////////////////////////////////////////////////////
//
//      Dependencies: None
//
/////////////////////////////////////////////////////////////////////////
//
//      Last commit info:       $Author: $
//                              $Date: $
//                              $Revision: $
//
/////////////////////////////////////////////////////////////////////////

package uk.ac.soton.itinnovation.gemss.server;

import java.rmi.RemoteException;
import javax.activation.DataHandler;

/**
 * Negotiation interface for the ApplicationExecuter. This interface supports the client/service provider negotiation operations
 * and the basic conversation ID operations required for a qos negotiation.
 */
public interface Negotiation {

	/* return a job ID given a neg ID.
	 * @param strNegConvID negotiation conv ID
	 * @return job ID or null if none available
	 */
      public String getJobCID( String strNegConvID ) throws RemoteException;

      /* return a negotiation ID given an account ID
      * @param strAccountConvID account conv ID
      * @return neg ID or null if none available
      */
      public String getNegCID( String strAccountConvID ) throws RemoteException;

	/* return the WSLA template for this service
	 * @param strNegConvID negotiation conv ID
	 * @return wsla template in string format, or null on error
	 */
      public String getWSLA(String strNegConvID) throws RemoteException;

	/* upload the request desc file
	 * @param strNegConvID negotiation conv ID
	 * @param dataHandler data handler from which file can be obtained
	 */
      public void uploadRequestDesc(String strNegConvID, DataHandler dataHandler) throws RemoteException;

	/* process an auction inform message (starts the auction)
	 * @param strNegConvID negotiation conv ID
	 * @param arrayMessage FIPA mesage string as a byte array (base64binary used for transport encoding but decoded at this stage)
	 */
      public void auctionInform( String strNegConvID, byte[] arrayMessage ) throws RemoteException;

	/* process an auction cfp message (call for proposals)
	 * @param strNegConvID negotiation conv ID
	 * @param arrayMessage FIPA mesage string as a byte array (base64binary used for transport encoding but decoded at this stage)
	 */
	public void auctionCFP( String strNegConvID, byte[] arrayMessage ) throws RemoteException;

	/* process an auction propose message (i.e. collect proposal from client)
	 * @param strNegConvID negotiation conv ID
	 * @return byte array containing the WSLA proposal as a string
	 */
	public byte[] auctionPropose( String strNegConvID ) throws RemoteException;

	/* process an auction accept proposal message (i.e. accept a proposal if it's still valid)
	 * @param strNegConvID negotiation conv ID
	 * @param arrayMessage FIPA mesage string as a byte array (base64binary used for transport encoding but decoded at this stage)
	 */
	public void auctionAcceptProposal( String strNegConvID, byte[] arrayMessage ) throws RemoteException;

	/* process an auction reject proposal message (i.e. reject proposal and finish auction)
	 * @param strNegConvID negotiation conv ID
	 * @param arrayMessage FIPA mesage string as a byte array (base64binary used for transport encoding but decoded at this stage)
	 */
	public void auctionRejectProposal( String strNegConvID, byte[] arrayMessage ) throws RemoteException;

	/* process an auction request message (i.e. exchange contarcts after an excepted bid)
	 * @param strNegConvID negotiation conv ID
	 * @param arrayMessage FIPA mesage string as a byte array (base64binary used for transport encoding but decoded at this stage)
	 * @return byte array containing a signed WSLA proposal
	 */
	public byte[] auctionRequest( String strNegConvID, byte[] arrayMessage ) throws RemoteException;

} // end of Negotiation

